/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.event;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.animation.EasingFunction;
import io.github.mortuusars.exposure.client.camera.CameraClient;
import io.github.mortuusars.exposure.client.camera.viewfinder.ViewfinderRegistry;
import io.github.mortuusars.exposure.client.capture.template.CameraCaptureTemplate;
import io.github.mortuusars.exposure.client.capture.template.CaptureTemplates;
import io.github.mortuusars.exposure.client.capture.template.PreloadingDummyCaptureTemplate;
import io.github.mortuusars.exposure.client.render.ItemFramePhotographRenderer;
import io.github.mortuusars.exposure.client.sound.UniqueSoundManager;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.network.handler.ClientPacketsHandler;
import io.github.mortuusars.exposure.network.packet.Packet;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.camera.CameraId;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import net.minecraft.class_1533;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class ClientEvents {
    public static void levelUnloaded() {
    }

    public static void login() {
        try {
            ClientEvents.preloadStuffToFixLagSpikes();
        }
        catch (Exception e) {
            Exposure.LOGGER.warn("Failed to preload stuff: {}", (Object)e.getMessage());
        }
    }

    private static void preloadStuffToFixLagSpikes() {
        ClientPacketsHandler.clearRenderingCache();
        boolean active = Minecrft.player().getActiveExposureCameraOptional().isEmpty();
        EasingFunction.EASE_OUT_EXPO.ease(0.5);
        ViewfinderRegistry.getConstructor(Exposure.Items.CAMERA.get()).apply((Object)new Camera((CameraHolder)Minecrft.player(), CameraId.create()){

            @Override
            public class_1799 getItemStack() {
                return new class_1799((class_1935)Exposure.Items.CAMERA.get());
            }

            @Override
            public Packet createSyncPacket() {
                return null;
            }
        });
        CameraClient.removeViewfinder();
        CaptureTemplates.get(Exposure.resource("dummy"));
        CameraCaptureTemplate cameraCaptureTemplate = new CameraCaptureTemplate();
        ExposureClient.cycles().enqueueTask(new PreloadingDummyCaptureTemplate().createTask(null));
        UniqueSoundManager.stop(Minecrft.player().method_5820(), Exposure.SoundEvents.CAMERA_BUTTON_CLICK.get());
    }

    public static void disconnect() {
        ClientEvents.resetRenderData();
    }

    public static void resetRenderData() {
        ExposureClient.exposureStore().clear();
        ExposureClient.renderedExposures().clearCache();
        ExposureClient.imageRenderer().clearCache();
    }

    public static boolean renderItemFrameItem(class_1533 itemFrame, class_4587 poseStack, class_4597 buffer, int packedLight) {
        if (!((Boolean)Config.Client.PHOTOGRAPH_RENDERS_IN_ITEM_FRAME.get()).booleanValue()) {
            return false;
        }
        class_1792 class_17922 = itemFrame.method_6940().method_7909();
        if (!(class_17922 instanceof PhotographItem)) {
            return false;
        }
        PhotographItem photographItem = (PhotographItem)class_17922;
        if (photographItem.getFrame(itemFrame.method_6940()).identifier().isEmpty()) {
            return false;
        }
        poseStack.method_22903();
        poseStack.method_22905(2.0f, 2.0f, 2.0f);
        ItemFramePhotographRenderer.render(itemFrame, poseStack, buffer, packedLight, photographItem, itemFrame.method_6940());
        poseStack.method_22909();
        return true;
    }

    public static void resourcesReloaded() {
        ExposureClient.exposureStore().clear();
        ExposureClient.renderedExposures().clearCache();
        ExposureClient.imageRenderer().clearCache();
    }
}

